\name{table.Distributions}
\alias{table.Distributions}
\title{Distributions Summary: Statistics and Stylized Facts}
\usage{
  table.Distributions(R, scale = NA, digits = 4)
}
\arguments{
  \item{R}{an xts, vector, matrix, data frame, timeSeries
  or zoo object of asset returns}

  \item{scale}{number of periods in a year (daily scale =
  252, monthly scale = 12, quarterly scale = 4)}

  \item{digits}{number of digits to round results to}
}
\description{
  Table of Monthly standard deviation, Skewness, Sample
  standard deviation, Kurtosis, Excess kurtosis, Sample
  Skweness and Sample excess kurtosis
}
\examples{
data(managers)
table.Distributions(managers[,1:8])

require("Hmisc")
result = t(table.Distributions(managers[,1:8]))

textplot(format.df(result, na.blank=TRUE, numeric.dollar=FALSE, cdec=c(3,3,1)),
rmar = 0.8, cmar = 2,  max.cex=.9, halign = "center", valign = "top",
row.valign="center", wrap.rownames=20, wrap.colnames=10,
col.rownames=c("red", rep("darkgray",5), rep("orange",2)), mar = c(0,0,3,0)+0.1)
title(main="Portfolio Distributions statistics")
}
\author{
  Matthieu Lestel
}
\references{
  Carl Bacon, \emph{Practical portfolio performance
  measurement and attribution}, second edition 2008 p.87
}
\seealso{
  \code{\link{StdDev.annualized}} \cr
  \code{\link{skewness}} \cr \code{\link{kurtosis}}
}
\keyword{distribution}
\keyword{models}
\keyword{multivariate}
\keyword{ts}

