% Generated by roxygen2 (4.0.1): do not edit by hand
\name{rmm}
\alias{rmm}
\title{Sample a Mallows Model}
\usage{
rmm(n, sigma0, theta, dist.name = "kendall", sampling.method = "distances",
  disk = FALSE)
}
\arguments{
\item{n}{the number of permutations to be generated}

\item{sigma0}{central permuation of the MM}

\item{theta}{dispersion parameter of the MM}

\item{dist.name}{optional name of the distance used in the MM. One of: kendall (default), cayley, hamming, ulam}

\item{sampling.method}{optional name of the sampling algorithm. One of: distances, multistage, gibbs (default)}

\item{disk}{optional can only be true if using the Distances sampling algorithm for generating under the Ulam distance.
Insted of generating the whole set of SYT and count of permutations per distance, it loads the info from a file in the disk}
}
\value{
A matrix contaning a sample of permutations from the specified ditribution
}
\description{
Generate a sample of n permutations from a Mallows Model (MM).
}
\examples{
rmm(2,c(1,2,3,4,5),1,"kendall", "distances")
rmm(2,c(1,2,3,4,5),1,"cayley", "distances")
rmm(2,c(1,2,3,4,5),1,"hamming", "distances")
rmm(2,c(1,2,3,4,5),1,"ulam", "distances")
rmm(2,c(1,2,3,4,5),1,"kendall", "multistage")
rmm(2,c(1,2,3,4,5),1,"cayley", "multistage")
}

