% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SklearnClassifierSettings.R
\name{setAdaBoost}
\alias{setAdaBoost}
\title{Create setting for AdaBoost with python DecisionTreeClassifier base estimator}
\usage{
setAdaBoost(
  nEstimators = list(10, 50, 200),
  learningRate = list(1, 0.5, 0.1),
  algorithm = list("SAMME"),
  seed = sample(1e+06, 1)
)
}
\arguments{
\item{nEstimators}{(list) The maximum number of estimators at which boosting is terminated. In case of perfect fit, the learning procedure is stopped early.}

\item{learningRate}{(list) Weight applied to each classifier at each boosting iteration. A higher learning rate increases the contribution of each classifier. There is a trade-off between the learningRate and nEstimators parameters
There is a trade-off between learningRate and nEstimators.}

\item{algorithm}{Only ‘SAMME’ can be provided. The 'algorithm' argument will be deprecated in scikit-learn 1.8.}

\item{seed}{A seed for the model}
}
\value{
a modelSettings object
}
\description{
Create setting for AdaBoost with python DecisionTreeClassifier base estimator
}
\examples{
\dontshow{ # dontrun reason: requires python's scikit-learn, checkSklearn() will error without it }
\dontrun{ 
model <- setAdaBoost(nEstimators = list(10),
                     learningRate = list(0.1),
                     seed = 42)
}
}
