\name{plot.PPSfit}
\alias{plot.PPSfit}
\title{Plots to validate a Pareto Positive Stable (PPS) fit}
\description{Plots to validate a PPS fit (typically from \code{PPS.fit()}) with different comparisons between empirical and theoretical functions.}
\usage{
\method{plot}{PPSfit}(x, which = 1:4, ask = prod(par("mfcol")) < length(which) && dev.interactive(),
 ylim, breaks, ...)
}
\arguments{
  \item{x}{a \code{PPSfit} Object.}
  \item{which}{values from 1 to 4 indicating the type of plot.}
  \item{ask}{an argument to control the plot window.}
  \item{ylim}{optional argument to control the y limits of the histogram. It is included to prevent non-desired scales on the y-axis.}
  \item{breaks}{optional argument to control the breakpoints of the histogram. See \code{hist} help for the details. It is included to prevent non-desired scales on the y-axis.}
  \item{\dots}{other arguments.}
}
\details{
The plots return:

1. The histogram of the observations and the fitted PPS density (\code{which = 1}). Optional \code{ylim} and \code{breaks} arguments are provided to prevent frequent imbalances between density and histogram scales in real data: they work as the analogue arguments of the default \code{hist} function when \code{which = 1}.

2. The empirical distribution function of data and the cumulative distribution function of the fitted model (\code{which = 2}).

3. A rank-size plot in log-log scale to check the Pareto or power-law behaviour of data (\code{which = 3}). In the X-axis the log of the observations appears; in the Y-axis, the log of the empirical survival function. If the scatter-plot is around a straight line, then the observations exhibit a power law behaviour. The plot also includes the curve with the theoretical survival function of the model specified in the first argument class \code{PPSfit}: only when \code{nu} is 1, that curve is going to be a straight line. 

4. A plot in a double log-log scale to check the adequacy of data to the PPS model (\code{which = 4}). On one hand, the X-axis shows the double log of the observations divided by the scale parameter, while the Y-axis shows the log of minus the log of the empirical survival function. On the other hand, the straight line determined by the linear relation between the survival function and the scaled data in a double log-log scale, in relation to the argument class \code{PPSfit} is added. The proximity of the points in the scatter-plot to that straight line is an evidence in favour of a PPS behaviour of data.
}

\references{
Sarabia, J.M and Prieto, F. (2009). The Pareto-positive stable distribution: A new descriptive model for city size data, \emph{Physica A: Statistical Mechanics and its Applications}, \bold{388}(19), 4179-4191.
}

\seealso{
\code{\link{PPS.fit}}
}
\examples{
x <- rPPS(50, 1.2, 100, 2.3)
fit <- PPS.fit(x)
par(mfrow=c(2,2))
plot(fit)
}
