% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placebo_test.R
\name{placebo_test}
\alias{placebo_test}
\title{Conduct a placebo test}
\usage{
placebo_test(
  pm.obj,
  panel.data,
  lag.in = NULL,
  number.iterations = 1000,
  confidence.level = 0.95,
  plot = FALSE,
  se.method = "bootstrap",
  parallel = FALSE,
  num.cores = 1,
  ...
)
}
\arguments{
\item{pm.obj}{an object of class \code{PanelMatch}}

\item{panel.data}{\code{PanelData} object}

\item{lag.in}{integer indicating earliest the time period(s) in the future for which the placebo test change in outcome will be calculated. Calculations will be made over the period t - max(lag) to t-2, where t is the time of treatment. The results are similar to those returned by \code{PanelEstimate()}, except t-1 is used as the period of comparison, rather than the lead window. If not specified, the placebo test is conducted for periods from t - max(lag) to t-2.}

\item{number.iterations}{integer specifying the number of bootstrap iterations. This argument only has an effect if standard errors are calculated with the bootstrap.}

\item{confidence.level}{confidence level for the calculated standard error intervals. Should be specified as a numeric between 0 and 1.}

\item{plot}{logical indicating whether or not a plot should be generated, or just return the raw data from the calculations}

\item{se.method}{character string describing the type of standard error to be used. Valid inputs include "bootstrap", "conditional" and "unconditional". When the QOI is ATE, only bootstrap can be used. See the documentation of this argument in \code{PanelEstimate()} for more.}

\item{parallel}{Logical. If TRUE and \code{se.method = "bootstrap"}, bootstrap procedure will be parallelized. Default is FALSE. If \code{se.method} is not set to \code{bootstrap}, this option does nothing."}

\item{num.cores}{Integer. Specifies the number of cores to use for parallelization. If \code{se.method = "bootstrap"} and \code{parallel = TRUE}, then this option will take effect. Otherwise, it will do nothing.}

\item{...}{extra arguments to be passed to \code{plot()}}
}
\value{
list with 2 or 3 elements: "estimate", which contains the point estimates for the test, "standard.errors" which has the standard errors for each period and optionally "bootstrapped.estimates", containing the bootstrapped point estimates for the test for each specified lag window period.
}
\description{
Calculate the results of a placebo test, looking at the change in outcome at time = t-1, compared to other pre-treatment periods in the lag window.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
# create subset of data for simplicity
PM.results <- PanelMatch(panel.data = dem.sub.panel, lag = 4, 
                         refinement.method = "ps.match", 
                         match.missing = TRUE, 
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         lead = 0:4, 
                         forbid.treatment.reversal = FALSE, placebo.test = TRUE)
placebo_test(PM.results, panel.data = dem.sub.panel, se.method = "unconditional", plot = FALSE)


}
