% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/placebo_test.R
\name{placebo_test}
\alias{placebo_test}
\title{placebo_test}
\usage{
placebo_test(
  pm.obj,
  data,
  lag.in = NULL,
  number.iterations = 1000,
  confidence.level = 0.95,
  plot = FALSE,
  se.method = "bootstrap",
  parallel = FALSE,
  num.cores = 1,
  ...
)
}
\arguments{
\item{pm.obj}{an object of class \code{PanelMatch}}

\item{data}{data.frame with the original data}

\item{lag.in}{integer indicating earliest the time period(s) in the future for which the placebo test change in outcome will be calculated. Calculations will be made over the period t - max(lag) to t-2, where t is the time of treatment. The results are similar to those returned by PanelEstimate(), except t-1 is used as the period of comparison, rather than the lead window. If not specified, the placebo test is conducted for periods from t - max(lag) to t-2.}

\item{number.iterations}{integer specifying the number of bootstrap iterations}

\item{confidence.level}{confidence level for the calculated standard error intervals}

\item{plot}{logical indicating whether or not a plot should be generated, or just return the raw data from the calculations}

\item{se.method}{character string describing the type of standard error to be used. Valid inputs include "bootstrap", "conditional" and "unconditional". When the QOI is ATE, only bootstrap can be used.}

\item{parallel}{Logical. If TRUE and \code{se.method = ``bootstrap''}, bootstrap procedure will be parallelized. Default is FALSE. If \code{se.method} is not set to \code{bootstrap}, this option does nothing.}

\item{num.cores}{Integer. Specifies the number of cores to use for parallelization. If \code{se.method = ``bootstrap''} and \code{parallel = TRUE}, then this option will take effect. Otherwise, it will do nothing.}

\item{...}{extra arguments to be passed to plot()}
}
\value{
list with 2 or 3 elements: "estimates", which contains the point estimates for the test, "standard.errors" which has the standard errors for each period and optionally "bootstrapped.estimates", containing the bootstrapped point estimates for the test for each specified lag window period.
}
\description{
Calculates results for a placebo test
}
\details{
Calculate the results of a placebo test, looking at the change in outcome at time = t-1, compared to other pre-treatment periods in the lag window.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
# create subset of data for simplicity
PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                         treatment = "dem", refinement.method = "mahalanobis",
                         data = dem.sub, match.missing = TRUE,
                         covs.formula = ~ tradewb,
                         size.match = 5, qoi = "att",
                         outcome.var = "y", lead = 0:4, forbid.treatment.reversal = FALSE,
                         placebo.test = TRUE)
placebo_test(PM.results, data = dem.sub, se.method = "unconditional", plot = FALSE)


}
