% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_set_R.r
\name{findContinuousTreated}
\alias{findContinuousTreated}
\title{findContinuousTreated}
\usage{
findContinuousTreated(
  dmat,
  treatedvar,
  time.var,
  unit.var,
  qoi,
  continuous.treatment.info
)
}
\arguments{
\item{dmat}{Sorted data frame or matrix containing data used to identify potential treated units. Must be specified in such a way that a combination of time and id variables will correspond to a unique row. Must also contain at least a continuous treatment variable column as well.}

\item{treatedvar}{Character string that identifies the name of the column in \code{dmat} that provides information about the continuous treatment variable}

\item{time.var}{Character string that identifies the name of the column in \code{dmat} that contains data about the time variable. This data must be integer that increases by one.}

\item{unit.var}{Character string that identifies the name of the column in \code{dmat} that contains data about the variable used as a unit id. This data must be integer}
}
\value{
\code{findContinuousTreated} returns a subset of the data in the \code{dmat} data frame, containing only treated units for which a matched set might exist
}
\description{
\code{findContinuousTreated} is used to identify t,id pairs of units for which a matched set might exist.
}
\keyword{internal}
