% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.pandemicEstimated.R,
%   R/summary.pandemicEstimated.R
\name{print.summary.pandemicEstimated}
\alias{print.summary.pandemicEstimated}
\alias{summary.pandemicEstimated}
\title{Summary method for \code{pandemicEstimated} objects}
\usage{
\method{print}{summary.pandemicEstimated}(x, ...)

\method{summary}{pandemicEstimated}(object, probs = c(0.025, 0.5, 0.975), digits = 3, info = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{"summary.pandemicEstimated"}.}

\item{...}{Currently unused.}

\item{object}{An object of S3 class \code{\link{pandemicEstimated-objects}}.}

\item{probs}{A numeric vector of quantiles of interest. The default is
\code{c(0.025,0.5,0.975)}.}

\item{digits}{Number of digits to use for formatting numbers.}

\item{info}{TRUE or FALSE: more details for output interpretation. The Default is TRUE.}
}
\value{
The summary method returns an object of class "summary.pandemicEstimated",
 which is a list with two arrays of summary statistics and diagnostics and
 others informations for use by the print method. The print method for summary.pandemicEstimated objects is called for its side effect
 and just returns its input.
}
\description{
The summary method for \code{pandemicEstimated} object of class S3 displays a compact summary of the
fitted model. See the \strong{Details} section below for descriptions of the different components of the printed
output.
}
\details{
\subsection{Point estimates}{
Mean and Quantiles computed from simulations.
For models fit using MCMC ("sampling", this is default algorithim of \code{pandemic_model} function),  the posterior sample
 is used. For others estimation algorithm see \code{\link[rstan]{sampling}}  (\pkg{rstan} package).
}

\subsection{Convergence and efficiency diagnostics for Markov Chains}{

Included in the summary are: split effective sample sizes (n_eff), Monte Carlo standard errors
(se_mean) and split Rhats.


The Monte Carlo standard error provides relevant information for a posterior sample with more than one chain.


The R-hat convergence diagnostic compares the
between- and within-chain estimates for model parameters and other univariate
quantities of interest. If chains have not mixed well (ie, the between- and
within-chain estimates don't agree), R-hat is larger than 1.
We recommend running at least four chains by default and only using the
sample if R-hat is less than 1.05.

}
\subsection{covidLPconfig}{
This subsection shows the main input settings used by the fitted model, and indicates whether default settings
of the CovidLP app (\url{http://est.ufmg.br/covidlp/home/en/})
were used (\code{covidLPconfig = TRUE} or \code{FALSE}).
Check the default settings of the CovidLP app in \code{\link{pandemic_model}}.
}
\subsection{Priors}{

A list with information about the prior distributions used and model restrictions (if there are any).
For more information go to \code{\link{models}}.


}
}
\examples{
\dontrun{
Y0=load_covid(country_name="Brazil",state_name="SP",last_date='2020-04-25')
output0=pandemic_model(Y0)
s=summary(output0)
s          #print method for summary.pandemicEstimated
names(s)  #see output list elements of summary
}

}
