% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairwiseD.R
\name{pairwised2}
\alias{pairwised2}
\title{pairing up observations of variables}
\usage{
pairwised2(data, measure = c("cor", "cov", "absmeandiff", "diffabs", "absvardiff",
             "abssddiff",  "absvarcoefdiff", "custom"),  period.length="FULL",
             exp.multiplier = 0, multiplier = 1, no.messages = FALSE,
             save.as = NULL,
             sep=";", dec=",", overlap=TRUE )
}
\arguments{
\item{data}{a data.frame, list or path to the input file in csv, xlsx or xls format.}

\item{measure}{operation that should be applied to every pair of time ordered vectors of observations. Built in                 options contains (z denotes first observation vector and g denotes the second observation):
\itemize{
   \item "cor": cor(z,g),
   \item "cov": cov(z,g),
   \item "absmeandiff": |mean(z)-mean(g)|,
   \item "absvardiff": |var(z)-var(g)|,
   \item "abssddiff": |sd(z)-sd(g)|,
   \item "absvarcoefdiff": |sd(z)/mean(z)-sd(g)/mean(g)|
   \item Moreover, option "custom" allows the user to specify any function of z and g.
   }}

\item{period.length}{Here, user can specify the length of the of the time ordered
vectors for which the measures are calculated. Default
value is the full length of the sample period (period.length="FULL").}

\item{exp.multiplier}{default value set to 0. Changes the decimal mark in all the observations in the
input file. Useful in cases when, for example, natural logarithm must be taken
from a number that is very close to 0.}

\item{multiplier}{default value set 1. Multiplies all the observations in the input file.}

\item{no.messages}{default value is FALSE. If FALSE, the package will show messages: about finishing the
calculations, destination file, potential error and wrong format of the input file.}

\item{save.as}{in this argument, user can specify: path for the destination folder, name of the file and desired format. Argument is given in the following form: "path/name.format". For example: "C:/Myfiles/Rfiles/pairwised_data.csv". If the argument is not specified default is set as "current R directory/name_of_the_input_file_paiwise_result.format_of_input_file". User can specify csv, xls and xlsx as the output format. If user does not specify the file format, the format will be the same as of the input format or xlsx in the case of data.frame/list input. If argument is equal to "none", output file is not generated.}

\item{sep}{symbol to be used for values separator in the input csv file (used if input file is set to be a csv file only). Default value is ";"}

\item{dec}{symbol to be used for decimal separator in the input file. Default value is ","}

\item{overlap}{default is set at TRUE. If TRUE then values of the measures are calculated for overlapping moving
windows trough time(ex. 1991-2005, 1992-2006,1993-2007,...etc.).FALSE can be set only if period.length
is lower than FULL.In this instance function will be calculating measures only for non-overlaping
windows (1991-1995,1996-2000,2001-2006,...etc.), which length is indicated in the parameter period.length.}
}
\value{
function returns its result as data.frame object.
}
\description{
Function for creating measures form time ordered vectors of observations in
   panel data setting according to built in or user specified formula.D
}
\examples{
   pairwised2(data =  GDPgrowth, measure = c("cor","cov","abssddiff","var(z)+var(g)-cov(z,g)"),
             period.length = 9,  exp.multiplier = 0, multiplier = 1, no.messages = FALSE,
             save.as = "GDPgrowthRESULTS.csv")
}
