% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWI2.R
\name{PWI2}
\alias{PWI2}
\title{Function to calculate prize winner indices based on bibliometric data}
\usage{
PWI2(
  bib_df,
  pw_pattern = "(BOYACK K)|(KLAVANS R)|(BORNMANN L)|(...",
  method = 1,
  verbosity = 1
)
}
\arguments{
\item{bib_df}{bibliographic dataframe variable from \link{convert2df}}

\item{pw_pattern}{character variable (optional parameter) that is passed as
search pattern to the \link{grep} function to identify the prize winners in
the data set}

\item{method}{integer variable (optional parameter) that determines if only
the authors in the dataset with number of papers and co-authors is returned
or if the prize winner index is calculated
0: return only a list with authors, number of papers, and number of co-authorships
1: calculate the prize winner index and return it alongside with number of papers
and number of co-authorships}

\item{verbosity}{level of verbosity (0=quiet and 1=informative)}
}
\value{
data frame of researcher names, PWI value, number of papers, and number of co-authors
}
\description{
This function calculates prize winner indices based on bibliometric data.
The default prize winners are the recipients of the Derek de Solla Price Memorial Medal.
Users can provide recipients of other prizes.
}
\details{
PWI2(bib_df=bibliographic_dataframe, pw_pattern = '(BOYACK K)|(KLAVANS R)|(BORNMANN L)|(BAR-ILAN J)|(BARILAN J)|
(WALTMAN L)|(THELWALL M)|(CRONIN B)|(PERSSON O)|(VINKLER P)|(MCCAIN K)|(INGWERSEN P)|
(LEYDESDORFF L)|(ROUSSEAU R)|(EGGHE L)|(GLANZEL W)|(GLAENZEL W)|(MOED H)|(IRVINE J)|
(MARTIN B)|(GRIFFITH B)|(VAN RAAN A)|(VANRAAN A)|(MERTON R)|(SCHUBERT A)|(BROOKES B)|
(NARIN F)|(NALIMOV V)|(BRAUN T)|(MORAVCSIK M)|(GARFIELD E)',
method=1, verbosity=1)
Only the argument bib_df is necessary. All other arguments are optional.

Literature:
\itemize{
\item Bornmann, L. & Haunschild, R. (in preparation). "Prize Winner Index".
}
}
\examples{
\donttest{
bib_df <- bibliometrix::convert2df('http://andreas-thor.github.io/cre/data/savedrecs_JOI2.txt')
JoI <- PWI2(bib_df)
head(JoI)
}
}
