% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_EBAMQualityControl.R
\name{wrcc_EBAMQualityControl}
\alias{wrcc_EBAMQualityControl}
\title{Apply Quality Control to raw WRCC EBAM tibble}
\usage{
wrcc_EBAMQualityControl(
  tbl,
  valid_Longitude = c(-180, 180),
  valid_Latitude = c(-90, 90),
  remove_Lon_zero = TRUE,
  remove_Lat_zero = TRUE,
  valid_Flow = c(16.7 * 0.95, 16.7 * 1.05),
  valid_AT = c(-Inf, 45),
  valid_RHi = c(-Inf, 45),
  valid_Conc = c(-Inf, 5000),
  flagAndKeep = FALSE
)
}
\arguments{
\item{tbl}{single site titbble created by \code{wrcc_parseData()}}

\item{valid_Longitude}{range of valid Longitude values}

\item{valid_Latitude}{range of valid Latitude values}

\item{remove_Lon_zero}{flag to remove rows where Longitude == 0}

\item{remove_Lat_zero}{flag to remove rows where Latitude == 0}

\item{valid_Flow}{range of valid Flow values}

\item{valid_AT}{range of valid AT values}

\item{valid_RHi}{range of valid RHi values}

\item{valid_Conc}{range of valid ConcHr values}

\item{flagAndKeep}{flag, rather than remove, bad data during the QC process}
}
\value{
Cleaned up titbble of WRCC monitor data.
}
\description{
Perform various QC measures on WRCC EBAM data.

The any numeric values matching the following are converted to \code{NA}
\itemize{
\item{\code{x < -900}}
\item{\code{x == -9.9899}}
\item{\code{x == 99999}}
}

The following columns of data are tested against valid ranges:
\itemize{
\item{\code{Flow}}
\item{\code{AT}}
\item{\code{RHi}}
\item{\code{ConcHr}}
}

A \code{POSIXct datetime} column (UTC) is also added based on \code{DateTime}.
}
\seealso{
\code{\link{wrcc_qualityControl}}
}
\keyword{WRCC}
