% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadDaily.R
\name{airsis_loadDaily}
\alias{airsis_loadDaily}
\title{Load Recent AIRSIS Monitoring Data}
\usage{

  airsis_loadDaily(baseUrl = "https://haze.airfire.org/monitoring/AIRSIS/RData/")
}
\arguments{
\item{baseUrl}{location of the AIRSIS latest data file}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Loads pre-generated .RData files containing the most recent AIRSIS data.

The daily files are generated once a day, shortly after midnight and contain data for the
previous 45 days. 

For the most recent data, use \code{airsis_loadLatest()}.

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AIRSIS/RData/latest}{https://haze.airfire.org/monitoring/AIRSIS/RData/latest}
}
\examples{
\dontrun{
airsis <- airsis_loadDaily()
}
}
\seealso{
\code{\link{airsis_load}}

\code{\link{airsis_loadLatest}}
}
\keyword{AIRSIS}
