% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_createMonitorObject.R
\name{airsis_createMonitorObject}
\alias{airsis_createMonitorObject}
\title{Obain AIRSIS Data and Create ws_monitor Object}
\usage{
airsis_createMonitorObject(startdate = strftime(lubridate::now(), "\%Y010100",
  tz = "UTC"), enddate = strftime(lubridate::now(), "\%Y\%m\%d23", tz =
  "UTC"), provider = NULL, unitID = NULL, clusterDiameter = 1000,
  zeroMinimum = TRUE,
  baseUrl = "http://xxxx.airsis.com/vision/common/CSVExport.aspx?",
  saveFile = NULL, ...)
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{provider}{identifier used to modify baseURL \code{['APCD'|'USFS']}}

\item{unitID}{character or numeric AIRSIS unit identifier}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see \code{addClustering()})}

\item{zeroMinimum}{logical specifying whether to convert negative values to zero}

\item{baseUrl}{base URL for data queries}

\item{saveFile}{optional filename where raw CSV will be written}

\item{...}{additional parameters are passed to type-specific QC functions}
}
\value{
A \emph{ws_monitor} object with AIRSIS data.
}
\description{
Obtains monitor data from an AIRSIS webservice and converts
it into a quality controlled, metadata enhanced \emph{ws_monitor} object
ready for use with all \code{monitor_~} functions.

Steps involved include:

\enumerate{
 \item{download CSV text}
 \item{parse CSV text}
 \item{apply quality control}
 \item{apply clustering to determine unique deployments}
 \item{enhance metadata to include: elevation, timezone, state, country, site name}
 \item{reshape AIRSIS data into deployment-by-property \code{meta} and and time-by-deployment \code{data} dataframes}
}

QC parameters that can be passed in the \code{\dots} include the following
valid data ranges as taken from \code{airsis_EBAMQualityControl()}:

\itemize{
\item{\code{valid_Longitude=c(-180,180)}}
\item{\code{valid_Latitude=c(-90,90)}}
\item{\code{remove_Lon_zero = TRUE}}
\item{\code{remove_Lat_zero = TRUE}}
\item{\code{valid_Flow = c(16.7*0.95,16.7*1.05)}}
\item{\code{valid_AT = c(-Inf,45)}}
\item{\code{valid_RHi = c(-Inf,45)}}
\item{\code{valid_Conc = c(-Inf,5.000)}}
}

Note that appropriate values for QC thresholds will depend on the type of monitor.
}
\note{
The downloaded CSV may be saved to a local file by providing an argument to the \code{saveFile} parameter.
}
\examples{
\dontrun{
usfs_1013 <- airsis_createMonitorObject(20150301, 20150831, 'USFS', unitID='1013')
monitorLeaflet(usfs_1013)
}
}
\seealso{
\code{\link{airsis_downloadData}}

\code{\link{airsis_parseData}}

\code{\link{airsis_qualityControl}}

\code{\link{addClustering}}

\code{\link{airsis_createMetaDataframe}}

\code{\link{airsis_createDataDataframe}}
}
\keyword{AIRSIS}
