% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_createMetaDataframe.R
\name{wrcc_createMetaDataframe}
\alias{wrcc_createMetaDataframe}
\title{Create WRCC Site Location Metadata Dataframe}
\usage{
wrcc_createMetaDataframe(df, existingMeta = NULL)
}
\arguments{
\item{df}{single site WRCC dataframe after metadata enhancement}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
A \code{meta} dataframe for use in a \emph{ws_monitor} object.
}
\description{
After an WRCC dataframe has been enhanced with 
additional columns generated by \code{addClustering} we are ready to 
pull out site information associated with unique deployments.

These will be rearranged into a dataframe organized as deployment-by-property
with one row for each monitor deployment.

This site information found in \code{df} is augmented so that we end up with a uniform
set of properties associated with each monitor deployment. The list of
columns in the returned \code{meta} dataframe is:

\preformatted{
> names(meta)
 [1] "AQSID"          "siteCode"       "siteName"       "status"        
 [5] "agencyID"       "agencyName"     "EPARegion"      "latitude"      
 [9] "longitude"      "elevation"      "timezone"       "GMTOffsetHours"
[13] "countryCode"    "FIPSMSACode"    "MSAName"        "FIPSStateCode" 
[17] "stateCode"      "GNISCountyCode" "countyName"     "monitorID"
[21] "monitorType"     
}
}
\seealso{
\code{\link{addGoogleMetadata}}

\code{\link{addMazamaMetadata}}
}
\keyword{WRCC}
