% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_ScanIDRate}
\alias{plot_ScanIDRate}
\title{Plot line graph of TopN over Retention time.}
\usage{
plot_ScanIDRate(data)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'scan.event.number', 'ratio', 'count'}
}
\value{
GGplot object
}
\description{
Number of Raw files must be 6 at most. Function will stop otherwise.
}
\examples{
  data = data.frame(fc.raw.file = factor(rep(c("d","a","x"), each=10), levels = c("d","a","x")),
                    scan.event.number = 1:10,
                    ratio = seq(40, 20, length.out=10),
                    count = seq(400, 200, length.out=10))
  plot_ScanIDRate(data)

}
