% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_dr.R
\name{psw.dr}
\alias{psw.dr}
\title{Propensity score weighting with doubly robust estimation}
\usage{
psw.dr(data, form.ps, weight, form.outcome, family = "gaussian", K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{form.outcome}{outcome model.}

\item{family}{outcome family, either \code{"gaussian"} or \code{"binomial"}. \code{family="gaussian"} by default.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight. The estimand is
closer to the average treatment effect (ATE) with larger value of \code{K}. \code{K=4} by default.}
}
\value{
A list of weighting method, fitted propensity score model, estimated propenstity scores, estimated propensity score weights,
doubly robust estimator and standard error estimator.
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{est.dr}{doubly robust estimator for mean difference when \code{family = "gaussian"}.}
\item{std.dr}{standard error for \code{est.dr}.}
\item{est.risk.dr}{doubly robust estimator for risk difference when \code{family = "binomial"}.}
\item{std.risk.dr}{standard error for \code{est.risk.dr}.}
}
\description{
\code{psw.dr} is the function to estimate the doubly robust estimator for mean difference
(mean outcome difference for \code{"gaussian"} family and risk difference for \code{"binomial"} family).
The doubly robust estimator is consistent when either the propensity score model or the outcome model is correctly specified.
}
\details{
\code{psw.dr} is used to estimate the doubly robust estimator, \eqn{\hat{\Delta}_{DR}},
and make inference using the sandwich variance that adjusts for the sampling variability in the estimated propensity score.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
# Outcome model
form.out <- "Y ~ X1 + X2 + X3 + X4";
tmp <- psw.dr( data = test_data, weight = "ATE", form.ps = form.ps,
form.outcome = form.out, family="gaussian" );

}
