% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specification.R
\name{LinTest}
\alias{LinTest}
\alias{LinTest}
\alias{WCB_LinTest}
\title{Conduct the linearity tests.}
\usage{
LinTest(use)

WCB_LinTest(use, iB = 100, parallel = F, cpus = 4)
}
\arguments{
\item{use}{an object of the class PSTR, created by \code{\link{NewPSTR}} function.}

\item{iB}{specify the number of repetitions in the bootstrap procedure. By default, it is 100.}

\item{parallel}{a boolean value showing if the parallel computation is applied.}

\item{cpus}{number of cores used in the parallel computation. The value will be ignored if \code{parallel=F}.}
}
\value{
a new object of the class PSTR containing the results from the linearity tests.

The object is a list containing the components made in \code{\link{NewPSTR}} and the following new components:
\item{test}{a list of the linearity test results. The length is the number of potential transition variables specified when creating the object of the class PSTR by calling \code{NewPSTR}. See argument \code{tvars} in \code{\link{NewPSTR}}. Each element of the list corresponds to the linearity test results based on the corresponding transition variable, and the element is also a list whose elements correspond to different numbers of switches.}
\item{sqtest}{a list of the linearity test results for selecting number of switches. It has the same length as \code{test}. Each element of the list corresponds to the linearity test results based on the corresponding transition variable, and the element is also a list whose elements correspond to different numbers of switches.}
\item{wcb_test}{a list of the linearity test results. The length is the number of potential transition variables specified when creating the object of the class PSTR by calling \code{NewPSTR}. See argument \code{tvars} in \code{\link{NewPSTR}}. Each element of the list is a matrix containing the linearity test results (p-values) based on the corresponding transition variable. The rows are different numbers of switches, and two columns from WB to WCB.}
\item{wcb_sqtest}{a list of the linearity test results for selecting number of switches. It has the same length as \code{test}. Each element of the list is a matrix containing the linearity test results based on the corresponding transition variable. The rows are different numbers of switches, and two columns from WB to WCB.}
}
\description{
These functions conduct the linearity tests against the alternative of a logistic smooth transition nonlinear component.
}
\details{
\code{LinTest} implements the linearity tests.

\code{WCB_LinTest} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) linearity tests.

The functions need the return value (an object of the class PSTR) from the \code{\link{NewPSTR}}. They copy the object, reuse its contents to produce the linearity test results, and then return a new object of the class PSTR. The user can choose to save the return value to a new object or simply to overwrite the object returned from \code{NewPSTR}. See the example below.

The functions conduct two kinds of linearity tests.

The first kind of tests does the linearity tests based on each potential transition variable specified in the argument \code{tvars} when the user calls the \code{\link{NewPSTR}} function. For each potential transition variable, the function conducts linearity tests for numbers of switches from 1 up to \code{im}. The linearity tests has the null hypothesis
\deqn{H_0^i: \beta_{i} = \beta_{i-1} = \beta_{i-2} = ... = \beta_{1} = 0}
for \eqn{i = 1, ..., m}, where \eqn{m} is the maximal number of switches \code{im}.

The second kind does the linearity tests for selecting the number of switches based on each potential transition variable. The linearity tests for selecting the number of switches has the null hypothesis
\deqn{H_0^i: \beta_{i} = 0 | \beta_{i+1} = \beta_{i+2} = ... = \beta_{m} = 0}
for \eqn{i = 1, ..., m}, where \eqn{m} is the maximal number of switches \code{im}.

The results of the linearity tests include four kinds of tests
\itemize{
  \item \eqn{\chi^2}-version Linearity test: the linearity LM test with asymptotically \eqn{\chi^2} distribution under the null hypothesis of linearity.
  \item F-version Linearity test: the linearity LM test with asymptotically \eqn{F} distribution under the null hypothesis of linearity. The finite sample actual size is supposed to be improved.
  \item \eqn{\chi^2}-version HAC Linearity test: the linearity LM test with asymptotically \eqn{\chi^2} distribution under the null hypothesis of linearity, which is heteroskedasticity and autocorrelation consistent.
  \item F-version HAC Linearity test: the linearity LM test with asymptotically \eqn{F} distribution under the null hypothesis of linearity, which is heteroskedasticity and autocorrelation consistent. The finite sample actual size is supposed to be improved.
}

The wild bootstrap (WB) tests are heteroskedasticity robust, while the wild cluster bootstrap (WCB) ones are both cluster-dependency and heteroskedasticity robust. Cluster-dependency implies that there can be dependency (autocorrelation) within individual, but no correlation across individuals. The WB and WCB tests may take quite a long time to run which depends on the model specification and the number of repetitions \code{iB}. It is strongly recommended to use super-computation server with many cores to run the code instead of a personal computer. The user may first try a small number of repetitions \code{iB} and estimate the time consumed for a larger number of \code{iB}.

The two functions never change the existing values in the input PSTR object. They add more values (attributes) into the input object and return.
}
\examples{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala'), iT=14) # create a new PSTR object

pstr = LinTest(pstr)

print(pstr, "tests")

\donttest{
# Don't forget to attach the package for the parallel computation.
library(snowfall)

# you should not run this on personal computer!
# pstr = WCB_LinTest(use=pstr, iB=5000, parallel=TRUE, cpus=50)

# a light version for checking on your personal computer.
pstr = WCB_LinTest(use=pstr, iB=4, parallel=TRUE, cpus=2)

print(pstr, "tests")
}

}
\seealso{
\code{\link{NewPSTR}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{specification}
