% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS_PGx_Lasso.R
\name{PRS_PGx_Lasso}
\alias{PRS_PGx_Lasso}
\title{Construct PGx PRS using penalized regression}
\usage{
PRS_PGx_Lasso(Y, Tr, G, intercept = TRUE, lambda, method, alpha = 0.5)
}
\arguments{
\item{Y}{a numeric vector containing the quantitative trait}

\item{Tr}{a numeric vector containing the treatment assignment}

\item{G}{a numeric matrix containing genotype information}

\item{intercept}{a logical flag indicating should intercept be fitted (default=TRUE) or set to be FALSE}

\item{lambda}{a numeric value indicating the penalty}

\item{method}{a logical flag for different penalized regression methods: 1 = PRS-PGx-L, 2 = PRS-PGx-GL, 3 = PRS-PGx-SGL}

\item{alpha}{a numeric value indicating the mixing parameter (only used when method = 3). alpha = 1 is the lasso penalty. alpha = 0 is the group lasso penalty}
}
\value{
A numeric list, the first sublist contains estimated prognostic effect sizes, the second sublist contains estimated predictive effect sizes
}
\description{
Shrink prognostic and predictive effect sizes simultaneously via the penalized term. With different assumptions on the relationship between the two effects, can be PRS-PGx-L (Lasso), PRS-PGx-GL (Group Lasso), and PRS-PGx-SGL (Sparse Group Lasso)
}
\details{
PRS-PGx-Lasso requires individudal-level data
}
\examples{
\donttest{
data(PRSPGx.example); attach(PRSPGx.example)
coef_est <- PRS_PGx_Lasso(Y, Tr, G, lambda = 1, method = 1)
summary(coef_est$coef.G)
summary(coef_est$coef.TG)
}

}
\references{
Yang, Y. & Zou, H. A fast unified algorithm for solving group-lasso penalize learning problems. Statistics and Computing 25, 1129-1141 (2015).

Simon, N., Friedman, J., Hastie, T. & Tibshirani, R. Fit a GLM (or cox model) with a combination of lasso and group lasso regularization. R package version, 1 (2015).

Zhai, S., Zhang, H., Mehrotra, D.V. & Shen, J. Paradigm Shift from Disease PRS to PGx PRS for Drug Response Prediction using PRS-PGx Methods (submitted).
}
\author{
Song Zhai
}
