% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking_functions.R
\name{runLinking}
\alias{runLinking}
\title{Run Scale Linking}
\usage{
runLinking(data, method, ...)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{method}{the type of linking to perform. Accepts:
\itemize{
  \item{\code{MM} for mean-mean}
  \item{\code{MS} for mean-sigma}
  \item{\code{HB} for Haebara method}
  \item{\code{SL} for Stocking-Lord method}
  \item{\code{FIXEDPAR} for fixed parameter calibration}
  \item{\code{CP} for calibrated projection using fixed parameter calibration on the anchor dimension}
  \item{\code{CPLA} for linear approximation of calibrated projection. This is identical to 'CP' in \code{\link{runLinking}} but uses approximation in \code{\link{runRSSS}}}
}
Linear transformation methods are performed with \code{\link[plink:plink-methods]{plink}} in \href{https://CRAN.R-project.org/package=plink}{'plink'} package.}

\item{...}{additional arguments to pass onto \code{\link[mirt]{mirt}} in \href{https://CRAN.R-project.org/package=mirt}{'mirt'} package.}
}
\value{
\code{\link{runLinking}} returns a \code{\link{list}} containing the scale linking results.
\itemize{
  \item{\code{constants}} linear transformation constants. \code{NA} if \code{method} argument was \code{FIXEDPAR}.
  \item{\code{ipar_linked}} item parameters calibrated to the response data, and linked to the anchor item parameters.
  \item{\code{ipar_anchor}} anchor item parameters used in linking.
}
}
\description{
\code{\link{runLinking}} is a function to obtain item parameters from the response data, and perform scale linking onto the metric of supplied anchor item parameters.
}
\examples{
\donttest{
out_link <- runLinking(data_asq, "SL", technical = list(NCYCLES = 1000))
out_link$constants   # transformation constants
out_link$ipar_linked # item parameters linked to anchor
out_link <- runLinking(data_asq, "FIXEDPAR")
out_link$ipar_linked # item parameters linked to anchor
}
}
