% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_check.R
\name{gen_check}
\alias{gen_check}
\title{Checking the plausibility and conversion of dom and af
\code{link{struc_preparation}}}
\usage{
gen_check(Rmx, af, dom, epis)
}
\arguments{
\item{Rmx}{maximum resistance value, if all gene loci under consideration are homozygous resistant. \eqn{\code{numeric}, \ge 1}.}

\item{af}{initial frequency of resistance alleles in the population. \code{numeric vector} with length of \code{ng} (number of genes) and elements in [0,1].}

\item{dom}{dominance of resistance alleles. \code{numeric vector} with length of \code{n_loci} (number of genes) and elements in [0,1].}

\item{epis}{epistasis value, describing the interaction between resistance alleles. \code{numeric}. \code{epis} = 0: no interaction i.e. additive effects of resistance alleles, \code{epis} < 0: effect of resistance alleles is smaller than additive, \code{epis} > 0: effect of resistance alleles is higher than additive.}
}
\description{
Before calling \code{struc_preparation} it is necessary to bring the geneticts into the correct form, which is mainly the correct dimensions.
}
\details{
If no genetics are required \code{af} has to be set to \code{NA}. The value of \code{dom} is adjusted to the length of \code{af}. If there are missmatches, the \code{dom} is cut or the first given value is repeated to fit the number of given alleles in \code{af}. The variables af and \code{dom} are corrected and \code{n_loci} is created, which is 0 when no genetics is included. If no value is given to \code{epis} it is set to 0.
}
