% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmoidal.R
\name{fit_sigmoidal}
\alias{fit_sigmoidal}
\title{Fit a Sigmoidal Model.}
\usage{
fit_sigmoidal(data, x_col, y_col, model_type)
}
\arguments{
\item{data}{A data frame containing the time (x_col) and completion (y_col) vectors.}

\item{x_col}{The name of the time vector.}

\item{y_col}{The name of the completion vector.}

\item{model_type}{The name of the sigmoidal model (Pearl, Gompertz, or Logistic).}
}
\value{
The function returns a list of results for the sigmoidal model.
}
\description{
Fit a Sigmoidal Model.
}
\examples{
data <- data.frame(time = 1:10, completion = c(5, 15, 40, 60, 70, 75, 80, 85, 90, 95))
fit <- fit_sigmoidal(data, "time", "completion", "logistic")
predictions <- predict_sigmoidal(fit, seq(min(data$time), max(data$time),
  length.out = 100), "logistic")
p <- ggplot2::ggplot(data, ggplot2::aes_string(x = "time", y = "completion")) +
  ggplot2::geom_point() +
  ggplot2::geom_line(data = predictions, ggplot2::aes(x = x, y = pred), color = "red") +
  ggplot2::labs(title = "Fitted Logistic Model", x = "time", y = "completion \%") +
  ggplot2::theme_minimal()
p
}
