% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPclassNodeViz.R
\name{PPclassNodeViz}
\alias{PPclassNodeViz}
\title{PPtree node visualization}
\usage{
PPclassNodeViz(PPclassOBJ,node.id,Rule,legend,std,image,diff.prop)
}
\arguments{
\item{PPclassOBJ}{PPregclass object}

\item{node.id}{node ID}

\item{Rule}{cutoff rule}

\item{legend}{flag to represent legend in the plot. Default value is TRUE}

\item{std}{flag to standardize data before drawing plot}

\item{image}{flag to draw image plot of correlation matrix}

\item{diff.prop}{percentage of number of variables with significant 
differences and shown in red in the bar chart style means}
}
\description{
Visualization tools to explore each node of PPtree
}
\details{
For the inner node, four plots are provided - the bar chart style plot with
projection pursuit coefficients of each variable, the histogram of the
projected data, the bar chart style plots with means of each variables for 
the left and the right group, and the image plot of correlations.
}
\examples{
data(iris)
Tree.result <- PPTreeclass(Species~., data = iris,"LDA")
Tree.result
PPclassNodeViz(Tree.result,1,1)
}
\references{
Lee, YD, Cook, D., Park JW, and Lee, EK(2013) 
PPtree: Projection Pursuit Classification Tree, 
Electronic Journal of Statistics, 7:1369-1386.
}
\keyword{tree}

