\name{lin_ic_plot}
\alias{lin_ic_plot}

\title{
Scatter plot of information criteria versus the number of lags in the linear Poisson NAR(p) model model with p lags and q
covariates (PNAR(p))
}

\description{
Scatter plot of information criteria versus the number of lags in the linear Poisson Network Autoregressive model of order \eqn{p} with \eqn{q} covariates (PNAR(\eqn{p})).
}

\usage{
lin_ic_plot(y, W, p = 1:10, Z = NULL, uncons = FALSE)
}

\arguments{
\item{y}{
An \eqn{N} x \eqn{TT} numerical matrix with the \eqn{N} multivariate
count time series over \eqn{TT} time periods.
}
\item{W}{
The \eqn{N} x \eqn{N} row-normalized non-negative adjacency matrix describing
the network. The main diagonal entries of the matrix should be zeros, all the
other entries should be non-negative and the maximum sum of elements over the
rows should equal one. The function row-normalizes the matrix if a non-normalized
adjacency matrix is provided.
}
\item{p}{
A vector with integer numbers, the range of lags in the model, for which the AIC,
BIC and QIC will be computed.
}
\item{Z}{
An \eqn{N} x \eqn{q} matrix of covariates (one for each column), where \eqn{q}
is the number of covariates in the model. Note that they must be non-negative.
}
\item{uncons}{
logical, if TRUE an unconstrained optimization without stationarity
constraints is performed (default is FALSE).
}
}

\details{
The function computes the AIC, BIC or QIC for a range of lag orders of the
linear Poisson Network Autoregressive model of order \eqn{p} with \eqn{q}
covariates (PNAR(\eqn{p})).
}

\value{
Three scatter plots with the lag order versus AIC, BIC and QIC and a matrix
with three columns, the AIC, BIC and QIC for each lag order.
}

\references{
Armillotta, M. and K. Fokianos (2022). Poisson network autoregression.
\url{https://arxiv.org/abs/2104.06296}
}

\author{
Mirko Armillotta, Michail Tsagris and Konstantinos Fokianos.
}

\seealso{
\code{\link{lin_estimnarpq}, \link{log_lin_ic_plot}
}
}

\examples{
data(crime)
data(crime_W)
lin_ic_plot(crime, crime_W, p = 1:3)
}


