% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepDownTrendTest.R
\name{stepDownTrendTest}
\alias{stepDownTrendTest}
\alias{stepDownTrendTest.default}
\alias{stepDownTrendTest.formula}
\title{Step Down Trend Tests}
\usage{
stepDownTrendTest(x, ...)

\method{stepDownTrendTest}{default}(
  x,
  g,
  test = c("leTest", "spearmanTest", "jonckheereTest", "cuzickTest", "chackoTest",
    "johnsonTest"),
  alternative = c("two.sided", "greater", "less"),
  continuity = FALSE,
  ...
)

\method{stepDownTrendTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  test = c("leTest", "spearmanTest", "jonckheereTest", "cuzickTest", "chackoTest",
    "johnsonTest"),
  alternative = c("two.sided", "greater", "less"),
  continuity = FALSE,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{test}{the trend test that shall be performed. Defaults to \code{"leTest"}.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"two.sided"}.}

\item{continuity}{logical indicator whether a continuity correction
shall be performed. Only relevant for \code{"jonckheereTest"}. Defaults to \code{FALSE}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"trendPMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs step-down trend test procedures for monotone responses
to detect NOEC (LOEC) according to OECD (2006).
}
\details{
According to OECD 2006 one can perform a test for trend
on responses from all dose groups including the control.
If the trend test is significant at the 0.05 level, the
high dose group is omitted, and the trend
statistic with the remaining dose groups is re-compute
The procedure is continued until the trend test is
first non-significant at the 0.05 level, then stop.

The NOEC is the highest dose
remaining at this stage. If this test is significant
when only the lowest dose and control remain,
then a NOEC cannot be established from the data.
}
\note{
Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers {0, 1, 2, ..., k} or
letters {a, b, c, ...}. Otherwise the function may not
select the correct values for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
res <- stepDownTrendTest(Y ~ DOSE, data = trout,
                         test = "jonckheereTest",
                         alternative = "less")
## print method
res
## summary method
summary(res)
}
\references{
OECD (2006) \emph{Current Approaches in the Statistical
Analysis of Ecotoxicity Data: A Guidance to Application},
OECD Series on Testing and Assessment \bold{52},
Paris: Organisation for Econonomic Co-operation and Development.
}
\seealso{
\code{\link{leTest}}, \code{\link{jonckheereTest}},
\code{\link{spearmanTest}}, \code{\link{cuzickTest}},
\code{\link{chackoTest}}, \code{\link{johnsonTest}}
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
