% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/williamsTest.R
\name{williamsTest}
\alias{williamsTest}
\alias{williamsTest.default}
\alias{williamsTest.formula}
\title{Williams Trend Test}
\usage{
williamsTest(x, ...)

\method{williamsTest}{default}(x, g, alternative = c("greater", "less"), ...)

\method{williamsTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{greater}}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"osrt"} that contains the following components:

\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated statistic(s)}
 \item{crit.value}{critical R-values for \eqn{\alpha = 0.05}.}
 \item{alternative}{a character string describing the alternative hypothesis.}
 \item{parameter}{the parameter(s) of the test distribution.}
\item{dist}{a string that denotes the test distribution.}
}
There are print and summary methods available.
}
\description{
Performs Williams' test for contrasting increasing (decreasing) dose levels of a treatment.
}
\details{
Williams' test is a step-down trend test for testing several treatment levels
with a zero control in a one-factorial design with normally distributed
errors of homogeneous variance. Let there be \eqn{k} groups including the control and let
the zero dose level be indicated with \eqn{i = 0} and the treatment
levels indicated as \eqn{1 \le i \le m}, then the following \eqn{m = k - 1} hypotheses are tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \bar{x}_0 = m_1 = \ldots = m_m, & \mathrm{A}_{m}: \bar{x}_0 \ge m_1 \ge \ldots m_m, \bar{x}_0 < m_m \\
\mathrm{H}_{m-1}: \bar{x}_0 = m_1 = \ldots = m_{m-1}, & \mathrm{A}_{m-1}: \bar{x}_0 \ge m_1 \ge \ldots m_{m-1}, \bar{x}_0 < m_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \bar{x}_0 = m_1, & \mathrm{A}_{1}: \bar{x}_0 < m_1,\\
\end{array}
}

where \eqn{m_i} denotes the isotonic mean of the \eqn{i}th dose level group.
The procedure starts from the highest dose level (\eqn{m}) to the the lowest dose level (\eqn{1}) and
stops at the first non-significant test. The consequent lowest effect dose
is the treatment level of the previous test number.

The function does not return p-values. Instead the critical t-values
as given in the tables of Williams (1972) for \eqn{\alpha = 0.05} (one-sided)
are looked up according to the degree of freedoms (\eqn{v}) and the order number of the
dose level (\eqn{i}) and (potentially) modified according to the given extrapolation
coefficient \eqn{\beta}.

Non tabulated values are linearly interpolated as recommended by Williams (1972).
The function \code{\link[stats]{approx}} is used.

For the comparison of the first dose level (i = 1) with the control, the critical t-value
from the Student t distribution is used (\code{\link[stats]{TDist}}).
}
\note{
In the current implementation, only tests on the level of \eqn{\alpha = 0.05}
can be performed. The included extrapolation function assumes either
a balanced design, or designs, where the number of replicates in the control excdeeds the number of replicates
in the treatment levels. A warning message appears, if the following
condition is not met, \eqn{1 \le n_0 / n_i \le 6} for \eqn{1 \le i \le m}.
}
\section{Source}{

The source code for the application of the pool adjacent violators
theorem to calculate the isotonic means
was taken from the file \code{"pava.f"}, which is included in the
package \pkg{Iso}:

 Rolf Turner (2015). Iso: Functions to Perform Isotonic Regression. R
 package version 0.0-17. \url{https://CRAN.R-project.org/package=Iso}.

The file \code{pava.f} is a Ratfor modification of Algorithm AS 206.1:

Bril, G., Dykstra, R., Pillers, C., Robertson, T. (1984)
Statistical Algorithms: Algorithm AS 206: Isotonic
Regression in Two Independent Variables, \emph{Appl. Statist.},
34, 352--357.

 The Algorith AS 206 is available from StatLib
\url{http://lib.stat.cmu.edu/apstat/}. The Royal Statistical Society
holds the copyright to these routines,
but has given its permission for their distribution provided that
no fee is charged.
}

\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
110, 125, 143, 148, 151,
136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("0", "I", "II")

## Williams Test
williamsTest(x ~ g)

}
\references{
Williams, D. A. (1971) A test for differences between treatment means
  when several dose levels are compared with a zero dose control,
  \emph{Biometrics} \bold{27}, 103--117.

Williams, D. A. (1972) The comparison of several dose levels with a zero
  dose control, \emph{Biometrics} \bold{28}, 519--531.
}
\seealso{
\code{\link[stats]{TDist}}, \code{\link[stats]{approx}}, \code{\link{print.osrt}},
\code{\link{summary.osrt}}
}
\keyword{htest}
