% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsim.vs.hard.r
\name{plsim.vs.hard}
\alias{plsim.vs.hard}
\alias{plsim.vs.hard.formula}
\alias{plsim.vs.hard.default}
\alias{stepWise}
\alias{dropOneVar}
\alias{varSelCore}
\alias{varSelCore.PPLSE}
\alias{varSelCore.StepWise}
\title{Variable Selection for Partial Linear Single Index Models}
\usage{
plsim.vs.hard(\dots)

\method{plsim.vs.hard}{formula}(formula, data, \dots)

\method{plsim.vs.hard}{default}(xdat=NULL, zdat, ydat, h=NULL, zeta_i=NULL, 
lambdaList=NULL, l1RatioList=NULL, lambda_selector="BIC", threshold=0.05,
Method="SCAD", verbose=TRUE, ParmaSelMethod="SimpleValidation", seed=0, \dots)
}
\arguments{
\item{\dots}{additional arguments.}

\item{formula}{a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{xdat}{input matrix (linear covariates). The model reduces to a single index model when \code{x} is NULL.}

\item{zdat}{input matrix (nonlinear covariates). \code{z} should not be NULL.}

\item{ydat}{input vector (response variable).}

\item{h}{a numerical value or a vector for bandwidth. If \code{h} is NULL, a default vector c(0.01,0.02,0.05,0.1,0.5)
will be set for it. \link{plsim.bw} is employed to select the optimal bandwidth when h is a vector or NULL.}

\item{zeta_i}{initial coefficients, optional (default: NULL). It could be obtained by the function \code{\link{plsim.ini}}.
\code{zeta_i[1:ncol(z)]} is the initial coefficient vector \eqn{\boldmath{\alpha}_0},
and \code{zeta_i[(ncol(z)+1):(ncol(z)+ncol(x))]} is the initial coefficient vector \eqn{\boldmath{\beta}_0}.}

\item{verbose}{bool, default: TRUE. Enable verbose output.}

\item{Method}{variable selection method, default: "SCAD". It could be "SCAD", "LASSO", "ElasticNet", "AIC" or "BIC".}

\item{lambdaList}{the parameter for the function \link{plsim.lam}, default: "NULL".}

\item{l1RatioList}{the parameter for the function \link{plsim.lam}, default: "NULL".}

\item{lambda_selector}{the parameter for the function \link{plsim.lam}, default: "BIC".}

\item{threshold}{the threshold to select important variable according to the estimated coefficients.}

\item{ParmaSelMethod}{the parameter for the function \link{plsim.bw}.}

\item{seed}{int, default: 0.}
}
\value{
\item{alpha_varSel}{selected variables in \code{z}.}
\item{beta_varSel}{selected variables in \code{x}.}
\item{fit_plsimest}{\code{fit_plsimest} is not NULL when \code{h} is a vector or NULL. 
For each bandwidth, \link{plsim.est} is employed to integrate selected variabels. Finally, the optimal
fitted model will be selected according to BIC.}
}
\description{
Variable Selection based on AIC, BIC, SCAD, LASSO and 
Elastic Net. The methods based on SCAD, LASSO and Elastic Net are implemented with Penalized Profile 
Least Squares Estimator, while AIC and BIC are implemented with Stepwise Regression.
}
\examples{

# EXAMPLE 1 (INTERFACE=FORMULA)
# To select variables with Penalized Profile Least Squares Estimation based on 
# the penalty LASSO.

n = 50
dx = 10
dz = 5
sigma = 0.2
alpha = matrix(c(1,3,1.5,0.5,0),dz,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(c(3,2,0,0,0,1.5,0,0.2,0.3,0.15),dx,1)

A = sqrt(3)/2-1.645/sqrt(12)
B = sqrt(3)/2+1.645/sqrt(12)
z = matrix(runif(n*dz),n,dz)
x = matrix(runif(n*dx),n,dx)
y = sin( (z\%*\%alpha - A) * 3.1415926 * (B-A) ) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

# Variable Selectioin Based on LASSO
res_varSel_LASSO = plsim.vs.hard(y~x|z,h=0.1,Method="LASSO")


# EXAMPLE 2 (INTERFACE=DATA FRAME)
# To select variables with Penalized Profile Least Squares Estimation based on 
# the penalty LASSO.

n = 50
dx = 10
dz = 5
sigma = 0.2
alpha = matrix(c(1,3,1.5,0.5,0),dz,1)
alpha = alpha/norm(alpha,"2")
beta = matrix(c(3,2,0,0,0,1.5,0,0.2,0.3,0.15),dx,1)

A = sqrt(3)/2-1.645/sqrt(12)
B = sqrt(3)/2+1.645/sqrt(12)
z = matrix(runif(n*dz),n,dz)
x = matrix(runif(n*dx),n,dx)
y = sin( (z\%*\%alpha - A) * 3.1415926 * (B-A) ) + x\%*\%beta + sigma*matrix(rnorm(n),n,1)

Z = data.frame(z)
X = data.frame(x)

# Variable Selectioin Based on LASSO
res_varSel_LASSO = plsim.vs.hard(xdat=X,zdat=Z,ydat=y,h=0.1,Method="LASSO")
}
