% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPLNfit-class.R
\name{ZIPLNfit_diagonal}
\alias{ZIPLNfit_diagonal}
\title{An R6 Class to represent a ZIPLNfit in a standard, general framework, with diagonal residual covariance}
\description{
An R6 Class to represent a ZIPLNfit in a standard, general framework, with diagonal residual covariance

An R6 Class to represent a ZIPLNfit in a standard, general framework, with diagonal residual covariance
}
\examples{
\dontrun{
# See other examples in function ZIPLN
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- ZIPLN(Abundance ~ 1, data = trichoptera, control = ZIPLN_param(covariance = "diagonal"))
class(myPLN)
print(myPLN)
}
}
\section{Super class}{
\code{\link[PLNmodels:ZIPLNfit]{PLNmodels::ZIPLNfit}} -> \code{ZIPLNfit_diagonal}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nb_param_pln}}{number of parameters in the PLN part of the current model}

\item{\code{vcov_model}}{character: the model used for the residual covariance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZIPLNfit_diagonal-new}{\code{ZIPLNfit_diagonal$new()}}
\item \href{#method-ZIPLNfit_diagonal-clone}{\code{ZIPLNfit_diagonal$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="optimize"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-optimize'><code>PLNmodels::ZIPLNfit$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="optimize_vestep"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-optimize_vestep'><code>PLNmodels::ZIPLNfit$optimize_vestep()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="predict"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-predict'><code>PLNmodels::ZIPLNfit$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="print"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-print'><code>PLNmodels::ZIPLNfit$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="show"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-show'><code>PLNmodels::ZIPLNfit$show()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PLNmodels" data-topic="ZIPLNfit" data-id="update"><a href='../../PLNmodels/html/ZIPLNfit.html#method-ZIPLNfit-update'><code>PLNmodels::ZIPLNfit$update()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit_diagonal-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit_diagonal-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{ZIPLNfit_diagonal}} model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit_diagonal$new(data, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit_diagonal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit_diagonal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit_diagonal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
