% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{summary.gsPLMIX}
\alias{summary.gsPLMIX}
\title{Summary of the Gibbs sampling procedure for a Bayesian mixture of Plackett-Luce models}
\usage{
\method{summary}{gsPLMIX}(object, quantiles = c(0.025, 0.25, 0.5, 0.75,
  0.975), hpd_prob = 0.95, digits = 2, ...)
}
\arguments{
\item{object}{Object of class \code{gsPLMIX} returned by the \code{gibbsPLMIX} function.}

\item{quantiles}{Numeric vector of quantile probabilities.}

\item{hpd_prob}{Numeric scalar in the grid of values spanning the interval (0,1) by 0.05, giving the posterior probability content of the HPD intervals. Supplied values outside the grid are rounded.}

\item{digits}{Number of decimal places for rounding the posterior summaries.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
A list of summary statistics for the \code{gsPLMIX} class object:

 \item{\code{statistics}}{ Numeric matrix with posterior summaries in each row (see 'Details').}
 \item{\code{quantiles}}{ Numeric matrix with posterior quantiles at the given \code{quantiles} probabilities in each row.}
 \item{\code{HPDintervals}}{ Numeric matrix with 100\eqn{*}\code{hpd_prob}\% HPD intervals in each row.}
 \item{\code{Modal_orderings}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the estimated posterior modal orderings of each mixture component.}
 \item{\code{call}}{ The matched call.}
}
\description{
\code{summary} method for class \code{gsPLMIX}. It provides summary statistics and credible intervals for the Gibbs sampling simulation of a Bayesian mixture of Plackett-Luce models.
}
\details{
Posterior summaries include means, standard deviations, naive standard errors of the means (ignoring autocorrelation of the chain) and time-series standard errors based on an estimate of the spectral density at 0. They correspond to the \code{statistics} element of the output returned by the \code{summary.mcmc} function of the \code{coda} package. Highest posterior density (HPD) intervals are obtained by recalling the \code{HPDinterval} function of the \code{coda} package.
}
\examples{

data(d_carconf)
GIBBS <- gibbsPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_iter=30, n_burn=10)

## Summary of the Gibbs sampling procedure
summary(GIBBS)
}
\references{
Plummer, M., Best, N., Cowles, K. and Vines, K. (2006). CODA: Convergence Diagnosis and Output Analysis for MCMC, \emph{R News}, \bold{6}, pages 7--11, ISSN: 1609-3631.
}
\seealso{
\code{\link[coda]{summary.mcmc}} and \code{\link[coda]{HPDinterval}}
}
\author{
Cristina Mollica and Luca Tardella
}
