% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_read.R
\name{pl_read}
\alias{pl_read}
\alias{read_pl}
\title{Read a set of PL Files}
\usage{
pl_read(path, ...)

read_pl(path, ...)
}
\arguments{
\item{path}{a path to a folder containing PL files. Can also be path or a URL
for a ZIP file, which will be downloaded and unzipped.}

\item{...}{passed on to \code{\link[readr:read_delim]{readr::read_delim()}}}
}
\value{
A list of data frames containing the four PL files.
}
\description{
PL files come in one of four types and are pipe-delimited with no header row.
This function speedily reads in the files and assigns the appropriate column
names and types.
}
\examples{
pl_ex_path <- system.file('extdata/ri2018_2020Style.pl', package = 'PL94171')
pl <- pl_read(pl_ex_path)
# or try `pl_read(pl_url("RI", 2010))`

}
