% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.outputMvo.R
\name{opt.outputMvo}
\alias{opt.outputMvo}
\title{Optimal Portfolio Weights and Performance}
\usage{
opt.outputMvo(opt, returns, digits = NULL, names = NULL, rf = 0.003)
}
\arguments{
\item{opt}{List output of optimize.portfolio}

\item{returns}{Multivariate xts object of portfolio assets returns}

\item{digits}{Integer number of significant digits with default NULL}

\item{names}{Character vector of names assigned to function output list}

\item{rf}{Numeric value with default 0.003}
}
\value{
Optimal a list containing the numeric weight vector, and the 
numeric values of the portfolio return mean, volatility, and Sharpe ratio
}
\description{
Converts output of PortfolioAnalytics function
optimize.portfolio which computes a minimum variance portfolio
to a list containing the portfolio weights vector, mean, volatility
and Sharpe Ratio.
}
\details{
This functions uses the weights returned by optimize.portfolio,
along with the returns to compute the portfolio mean return and volatility,
and along with the risk-free rate rf it computes the Sharpe Ratio.
}
\examples{
args(opt.outputMvo)
}
