% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetLabels}
\alias{PCMTreeSetLabels}
\title{Set tip and internal node labels in a tree}
\usage{
PCMTreeSetLabels(tree, labels = as.character(1:PCMTreeNumNodes(tree)),
  inplace = TRUE)
}
\arguments{
\item{tree}{a phylo object}

\item{labels}{a character vector in the order 1:PCMTreeNumNodes(tree) as denoted in the
tree$edge matrix.}

\item{inplace}{a logical indicating if the change should be done in place on the object
in the calling environment (in this case tree must not be a temporary object, e.g.
returned by another function call). Default is TRUE.}
}
\value{
if inplace = FALSE, a copy of tree with set or modified tree$tip.label and tree$node.label, otherwise nothing.
}
\description{
Set tip and internal node labels in a tree
}
