% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMGenerateModelTypes}
\alias{PCMGenerateModelTypes}
\title{Generate default model types for given PCM base-classes}
\usage{
PCMGenerateModelTypes(baseTypes = c("BM", "OU"),
  parametrizations = c("default", "all"), sourceFile = NULL)
}
\arguments{
\item{baseTypes}{a character vector specifying base S3-class names for which
the default parametrizations (sub-classes) will be generated. Defaults to
`c("BM", "OU")`.}

\item{parametrizations}{a character string specifying which one of
`PCMListParameterizations` or `PCMListDefaultParameterizations` should be used.
This argument should be one of:
\itemize{
\item{"all"}{for calling `PCMListParameterizations`}
\item{"default"}{for calling `PCMListDefaultParameterizations`}
}}

\item{sourceFile}{NULL or a character string indicating a .R filename, to
which the automatically generated code will be saved. If NULL (the default),
the generated source code is evaluated and the S3 methods are defined in the
global environment. Default: NULL.}
}
\value{
This function has side effects only and does not return a value.
}
\description{
This function calls `PCMListParameterizations` or
`PCMListDefaultParameterizations` and generates the corresponding
`PCMParentClasses` and `PCMSpecify` methods in the global environment.
}
\seealso{
PCMListDefaultParameterizations
}
