% Generated by roxygen2 (4.0.2): do not edit by hand
\name{KEGGpredict}
\alias{KEGGpredict}
\title{Predict KEGG pathway annotations for proteins}
\usage{
KEGGpredict(Pfile, PPIdb, Gene2Annotation, p_value=0.001, IDtoNAME)
}
\arguments{
\item{Pfile}{A data frame returned from the function "SignificantPairs"}

\item{PPIdb}{A 2-column data frame consisting of binary interactions where each row i.e. c(A, B) represents an undirected edge (interaction) between gene A and gene B.}

\item{Gene2Annotation}{A list that maps KEGG pathway ID to genes. The names should be gene symbols and the elements should be KEGG pathways. i.e.

    $IGSF5

    [1] "hsa04530" "hsa05120"

    $OR2T8

    [1] "hsa04740"

    $hCG_1776980

    [1] "hsa00020" "hsa00190" "hsa01100" "hsa05010" "hsa05012" "hsa05016"

    ......}

\item{p_value}{A cut-off for p-values from Fishers exact test when predicting KEGG pathway annotations}

\item{IDtoNAME}{A table that maps KEGG pathway ID to KEGG pathway names.}
}
\value{
This function returns a data frame with column names: "Symbol", "KEGGID", "PathName", "Ratio" and "Pvalue". "Symbol" is the name of the
node this function predicts KEGG annotation for. "KEGGID" and "PathName" are the predicted KEGG pathway identifier and the pathway name, respectively.
"Ratio" is the proportion of neighboring nodes that have the predicted KEGG annotation. "Pvalue" is calculated from the "Ratio" by Fishers exact test.
}
\description{
This function uses a direct annotation scheme to predict KEGG pathway annotations for proteins in the network derived with the PAND algorithm.
}
\seealso{
\code{\link{SignificantPairs}}, \code{\link{ProteinCluster}}, \code{\link{GOpredict}}, \code{\link{SignificantSubcluster}}
}

