% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOctaveLevel.R
\name{createOctaveLevel}
\alias{createOctaveLevel}
\title{Create Octave Level Measurements}
\usage{
createOctaveLevel(
  x,
  type = c("ol", "tol"),
  freqRange = NULL,
  method = c("sum", "mean")
)
}
\arguments{
\item{x}{dataframe of soundscape metrics}

\item{type}{either \code{'ol'} to create octave level or \code{'tol'} to create
third octave level measures}

\item{freqRange}{a vector of the minimum and maximum center frequencies (Hz) desired
for the output. If \code{NULL}, full available range of frequencies will be used.}

\item{method}{the summary method to apply to soundscape metrics within the octave band,
one of \code{'sum'} or \code{'mean'}. The default \code{'sum'} should be used in
almost all cases.}
}
\value{
a dataframe with summarised octave level band measurements
}
\description{
Creates octave or third octave level measurements from finer
resolution soundscape metrics, like Power Spectral Density (PSD) or
Hybrid Millidecade (HMD) measures
}
\examples{
psd <- checkSoundscapeInput(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
str(psd)
tol <- createOctaveLevel(psd, type='tol')
str(tol)
ol <- createOctaveLevel(tol, type='ol')
str(ol)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
