% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWaveform.R
\name{plotWaveform}
\alias{plotWaveform}
\alias{plotSpectrogram}
\alias{plotWigner}
\title{Plot Graphical Representations of Waveforms}
\usage{
plotWaveform(x, UID)

plotSpectrogram(x, UID, sr = NULL, ...)

plotWigner(x, UID, sr = NULL, ...)
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object, a list of \linkS4class{AcousticEvent}
objects, or a single \linkS4class{AcousticEvent} object}

\item{UID}{the UID(s) of the individual detections to fetch the binary
data for}

\item{sr}{if \code{NULL} (default) will try to read sample rate from your
data. If provided as a value will override sample rate in the data.}

\item{\dots}{other arguments to pass to the spectrogram or wigner functions}
}
\value{
Nothing, just shows plots for every channel of the waveform for
  each UID provided
}
\description{
Fetches matching binary data from a single or multiple
  detections in an \linkS4class{AcousticStudy}  object, then plot
  the resulting data
}
\details{
The \code{plotSpectrogram} function uses the function
  \code{\link[signal]{specgram}} to plot the spectrogram, see this function
  for plotting options. The \code{plotWigner} function uses the function
  \code{\link[PAMmisc]{wignerTransform}} to plot the Wigner-Ville transform,
  see this function for options.
}
\examples{

data(exStudy)
plotWaveform(exStudy, 8000003)
plotSpectrogram(exStudy, 8000003)
plotWigner(exStudy, 8000003)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
