% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAMA.PL.R
\name{PAMA.PL}
\alias{PAMA.PL}
\title{This function implements Bayesian inference of PAMA model with partial lists.}
\usage{
PAMA.PL(datfile, PLdatfile, nRe, iter)
}
\arguments{
\item{datfile}{A matrix or dataframe. This is the data where our algorithm will work on. Each colomn denotes a ranker's ranking. The data should be in entity-based format.}

\item{PLdatfile}{A matrix or dataframe.  It contains all the partial lists. Each colomn denotes a partial list.}

\item{nRe}{A number. Number of relevant entities.}

\item{iter}{A number. Numner of iterations of MCMC. Defaulted as 1000.}
}
\value{
List. It contains Bayesian posterior samples of all the parameters and log-likelihood.
\enumerate{
  \item I.mat: posterior samples of I
  \item phi.mat: posterior samples of phi
  \item smlgamma.mat: posterior samples of gamma
  \item l.mat: posterior samples of log-likelihood.
}
}
\description{
This function implements Bayesian inference of PAMA model with partial lists.
}
\details{
The partial lists are handle by Data Augmentation strategy.
}
\examples{
a=NBANFL()
PAMA.PL(a$NBA,a$NBAPL,nRe=10,iter=1)
\donttest{PAMA.PL(a$NBA,a$NBAPL,nRe=10,iter=100)}

}
\references{
Wanchuang Zhu, Yingkai Jiang, Jun S. Liu, Ke Deng (2021) Partition-Mallows Model and Its Inference for Rank Aggregation *Journal of the American Statistical Association*
}
\author{
Wanchuang Zhu, Yingkai Jiang, Jun S. Liu, Ke Deng
}
