% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACLasso.R
\name{generate.data}
\alias{generate.data}
\title{Function to Randomly Generate Data (with Constraints)}
\usage{
generate.data(n = 1000, p = 10, m = 5, cov.mat = NULL, s = 5,
  sigma = 1, glasso = F, err = 0)
}
\arguments{
\item{n}{number of rows in randomly-generated data set (default is 1000)}

\item{p}{number of variables in randomly-generated data set (default is 10)}

\item{m}{number of constraints in randomly-generated constraint matrix (default is 5)}

\item{cov.mat}{a covariance matrix applied in the generation of data to impose a correlation structure. Default is NULL (no correlation)}

\item{s}{number of true non-zero elements in coefficient vector beta1 (default is 5)}

\item{sigma}{standard deviation of noise in response (default is 1, indicating standard normal)}

\item{glasso}{should the generalized Lasso be used (TRUE) or standard Lasso (FALSE). Default is FALSE}

\item{err}{error to be introduced in random generation of coefficient values. Default is no error (err = 0)}
}
\value{
\code{x} generated \code{x} data

\code{y} generated response \code{y} vector

\code{C.full} generated full constraint matrix (with constraints of the form \code{C.full}*\code{beta}=\code{b})

\code{b} generated constraint vector \code{b}

\code{b.run} if error was included, the error-adjusted value of \code{b}

\code{beta} the complete beta vector, including generated \code{beta1} and \code{beta2}
}
\description{
This function is primarily used for reproducibility. It will generate a data set of
a given size with a given number of constraints for testing function code.
}
\examples{
random_data = generate.data(n = 500, p = 20, m = 10)
dim(random_data$x)
head(random_data$y)
dim(random_data$C.full)
random_data$beta
}
\references{
Gareth M. James, Courtney Paulson, and Paat Rusmevichientong (JASA, 2019) "Penalized and Constrained Optimization."
(Full text available at http://www-bcf.usc.edu/~gareth/research/PAC.pdf)
}
