% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pOwen.R
\name{powen}
\alias{powen}
\alias{powen1}
\alias{powen2}
\alias{powen3}
\alias{powen4}
\title{Owen distribution functions when \ifelse{html}{\out{&delta;<sub>1</sub>>&delta;<sub>2</sub>}}{\eqn{\delta_1>\delta_2}}}
\usage{
powen1(nu, t1, t2, delta1, delta2, algo = 2)

powen2(nu, t1, t2, delta1, delta2, algo = 2)

powen3(nu, t1, t2, delta1, delta2, algo = 2)

powen4(nu, t1, t2, delta1, delta2, algo = 2)
}
\arguments{
\item{nu}{integer greater than \eqn{1}, the number of degrees of freedom;
infinite allowed}

\item{t1, t2}{two numbers, positive or negative, possible infinite}

\item{delta1, delta2}{two vectors of possibly infinite numbers with the same length,
the noncentrality parameters;
must satisfy \code{delta1>delta2}}

\item{algo}{the algorithm used, \code{1} or \code{2}}
}
\value{
A vector of numbers between \eqn{0} and \eqn{1}, possibly
containing some \code{NaN}.
}
\description{
Evaluates the Owen distribution functions
when the noncentrality parameters satisfy \ifelse{html}{\out{&delta;<sub>1</sub>>&delta;<sub>2</sub>}}{\eqn{\delta_1>\delta_2}} and
the number of degrees of freedom is integer.
\itemize{
\item \code{powen1} evaluates \ifelse{html}{\out{P(T<sub>1</sub> &le; t<sub>1</sub>, T<sub>2</sub> &le; t<sub>2</sub>)}}{\eqn{P(T_1\le t_1, T_2 \le t_2)}}
(Owen's equality 8)
\item \code{powen2} evaluates \ifelse{html}{\out{P(T<sub>1</sub> &le; t<sub>1</sub>, T<sub>2</sub> > t<sub>2</sub>)}}{\eqn{P(T_1\le t_1, T_2 > t_2)}}
(Owen's equality 9)
\item \code{powen3} evaluates \ifelse{html}{\out{P(T<sub>1</sub> > t<sub>1</sub>, T<sub>2</sub> > t<sub>2</sub>)}}{\eqn{P(T_1> t_1, T_2 > t_2)}}
(Owen's equality 10)
\item \code{powen4} evaluates \ifelse{html}{\out{P(T<sub>1</sub> > t<sub>1</sub>, T<sub>2</sub> &le; t<sub>2</sub>)}}{\eqn{P(T_1> t_1, T_2 \le t_2)}}
(Owen's equality 11)
}
}
\note{
When the number of degrees of freedom is odd, the procedure resorts to
the Owen T-function (\code{\link{OwenT}}).
}
\examples{
nu=5; t1=2; t2=1; delta1=3; delta2=2
# Wolfram integration gives 0.1394458271284726
( p1 <- powen1(nu, t1, t2, delta1, delta2) )
# Wolfram integration gives 0.0353568969628651
( p2 <- powen2(nu, t1, t2, delta1, delta2) )
# Wolfram integration gives 0.806507459306199
( p3 <- powen3(nu, t1, t2, delta1, delta2) )
# Wolfram integration gives 0.018689824158
( p4 <- powen4(nu, t1, t2, delta1, delta2) )
# the sum should be 1
p1+p2+p3+p4
}
\references{
Owen, D. B. (1965).
A special case of a bivariate noncentral t-distribution.
\emph{Biometrika} \bold{52}, 437-446.
}
\seealso{
Use \code{\link{psbt}} for general values of \code{delta1} and \code{delta2}.
}
