% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specialOwen2.R
\name{spowen2}
\alias{spowen2}
\title{Special case of second Owen distribution function}
\usage{
spowen2(nu, t, delta, algo = 2)
}
\arguments{
\item{nu}{positive integer, possibly infinite}

\item{t}{positive number}

\item{delta}{vector of positive numbers}

\item{algo}{the algorithm used, \code{1} or \code{2}}
}
\value{
A vector of numbers between 0 and 1.
}
\description{
Evaluation of the second Owen distribution function in a
special case (see details).
}
\details{
The value of \code{spowen2(nu, t, delta)} is the same as the value
of \code{powen2(nu, t, -t, delta, -delta)}, but it is evaluated more efficiently.
}
\examples{
spowen2(4, 1, 2) == powen2(4, 1, -1, 2, -2)
}
\seealso{
\code{\link{powen2}}
}
