% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student.R
\name{ptOwen}
\alias{ptOwen}
\title{Student CDF with integer number of degrees of freedom}
\usage{
ptOwen(q, nu, delta = 0)
}
\arguments{
\item{q}{quantile, a finite number}

\item{nu}{integer greater than \eqn{1}, the number of degrees of freedom;
possibly infinite}

\item{delta}{numeric vector of noncentrality parameters; possibly infinite}
}
\value{
Numeric vector, the CDF evaluated at \code{q}.
}
\description{
Cumulative distribution function of the noncentrel Student
distribution with an integer number of degrees of freedom.
}
\note{
The results are theoretically exact when the number of degrees of
freedom is even.
When odd, the procedure resorts to the Owen T-function.
}
\examples{
ptOwen(2, 3) - pt(2, 3)
ptOwen(2, 3, delta=1) - pt(2, 3, ncp=1)
}
\references{
Owen, D. B. (1965).
A special case of a bivariate noncentral t-distribution.
\emph{Biometrika} \bold{52}, 437-446.
}
