% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutlierDetection.R
\name{OutlierDetection}
\alias{OutlierDetection}
\title{Outlier Detection(Intersection of all the methods)}
\usage{
OutlierDetection(x, k = 0.05 * nrow(x), cutoff = 0.95,
  Method = "euclidean", rnames = FALSE, depth = FALSE,
  dense = FALSE, distance = FALSE, dispersion = FALSE)
}
\arguments{
\item{x}{dataset for which outliers are to be found}

\item{k}{No. of nearest neighbours to be used for for outlier detection using bootstrapping, default value is 0.05*nrow(x)}

\item{cutoff}{Percentile threshold used for distance, default value is 0.95}

\item{Method}{Distance method, default is Euclidean}

\item{rnames}{Logical value indicating whether the dataset has rownames, default value is False}

\item{depth}{Logical value indicating whether depth based method should be used or not, default is False}

\item{dense}{Logical value indicating whether density based method should be used or not, default is False}

\item{distance}{Logical value indicating whether distance based methods should be used or not, default is False}

\item{dispersion}{Logical value indicating whether dispersion based methods should be used or not, default is False}
}
\value{
Outlier Observations: A matrix of outlier observations

Location of Outlier: Vector of Sr. no. of outliers
}
\description{
Takes a dataset and find its outliers using combination of different method
}
\details{
OutlierDetection finds outlier observations for the data using different methods and based on all the methods considered, labels an observation as outlier(intersection of all the methods). For bivariate data, it also shows the scatterplot of the data with labelled outliers.
}
\examples{
OutlierDetection(iris[,-5])
}
