% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ostats.R
\name{Ostats}
\alias{Ostats}
\title{Calculate O-statistics (community-level pairwise niche overlap statistics)}
\usage{
Ostats(
  traits,
  plots,
  sp,
  discrete = FALSE,
  circular = FALSE,
  output = "median",
  weight_type = "hmean",
  run_null_model = TRUE,
  nperm = 99,
  nullqs = c(0.025, 0.975),
  shuffle_weights = FALSE,
  swap_means = FALSE,
  random_seed = NULL,
  unique_values = NULL,
  circular_args = list(),
  density_args = list(),
  verbose = FALSE
)
}
\arguments{
\item{traits}{a numeric vector or matrix of trait measurements. The number of elements
in the vector or number of rows in the matrix is the number of individuals,
and the number of columns of the matrix is the number of traits.}

\item{plots}{a factor with length equal to \code{nrow(traits)} that indicates the
community each individual belongs to.}

\item{sp}{a factor with length equal to \code{nrow(traits)} that indicates the taxon
of each individual.}

\item{discrete}{whether trait data may take continuous or discrete values. Defaults to
\code{FALSE} (all traits continuous). A single logical value or a logical
vector with length equal to the number of columns in traits. See details below.}

\item{circular}{whether trait data are circular (e.g., hours or angles). Defaults to
\code{FALSE} (all traits non-circular). A single logical value or a logical
vector with length equal to the number of columns in traits. See details below.}

\item{output}{specifies whether median or mean is calculated. Default \code{"median"}.}

\item{weight_type}{specifies weights to be used to calculate the median or mean.
Default \code{"hmean"} (harmonic mean), meaning each pair of species is weighted
by the harmonic mean of abundances.}

\item{run_null_model}{whether to run a null model (if \code{TRUE}) and evaluate the
O-statistics against it, or simply return the raw O-statistics (if \code{FALSE}).
Defaults to \code{TRUE}.}

\item{nperm}{the number of null model permutations to generate. Defaults to 99.}

\item{nullqs}{numeric vector of probabilities with values in [0,1] to set
effect size quantiles. Defaults to \code{c(0.025, 0.975)}.}

\item{shuffle_weights}{If \code{TRUE}, shuffle weights given to pairwise overlaps
within a community when generating null models.}

\item{swap_means}{If \code{TRUE}, swap means of body sizes within a community when
generating null models.}

\item{random_seed}{User may supply a random seed to enable reproducibility
of null model output. A warning is issued, and a random seed is generated
based on the local time, if the user does not supply a seed.}

\item{unique_values}{Vector of all possible discrete values that \code{traits}
can take. Only used if \code{discrete = TRUE} and \code{circular = TRUE}.}

\item{circular_args}{optional list of additional arguments to pass to
\code{\link[circular]{circular}}. Only used if \code{circular = TRUE} and
\code{discrete = FALSE}.
Note that continuous circular data must be provided in radian units.}

\item{density_args}{additional arguments to pass to \code{\link[stats]{density}}, such as
\code{bw}, \code{n}, or \code{adjust}. If none are provided, default values
are used.}

\item{verbose}{If \code{TRUE}, progress messages are displayed. Defaults to \code{FALSE}.}
}
\value{
The function returns a list containing four objects:
\item{overlaps_norm}{a matrix showing the O-statistic for each trait and each community,
  with the area under all density functions normalized to 1.}
\item{overlaps_unnorm}{a matrix showing O-stats calculated with the area under all density
  functions proportional to the number of observations in that group.}
\item{overlaps_norm_ses}{List of matrices of effect size statistics against a null model
  with the area under all density functions normalized to 1. \code{ses} contains the
  effect sizes (z-scores), \code{ses_lower} contains the effect size lower critical values
  for significance at the level determined by \code{nullqs}, and \code{ses_upper}
  contains the upper critical values. \code{raw_lower} and \code{raw_upper} are
  the critical values in raw units ranging from 0 to 1.}
\item{overlaps_unnorm_ses}{List of matrices of effect size statistics against a null model
  with the area under all density functions proportional to the number
  of observations in that group. Elements are as in \code{overlaps_norm_ses}.}
}
\description{
This is the primary function in the Ostats package. It calculates O-statistics
by finding the trait density overlap among all pairs of species in each
community and taking the mean or median. Next it optionally evaluates the
O-statistics against a local null model. This is done separately for each trait.
}
\details{
This function calculates overlap statistics and optionally evaluates them
  against a local null model. By default, it calculates the median of pairwise
  overlaps, weighted by harmonic mean of species abundaces of the species
  pairs in each community. Two results are produced, one normalizing the area
  under all density functions to 1, the other making the area under all density
  functions proportional to the number of observations in that group.

  If \code{discrete = FALSE}, continuous kernel density functions are estimated for
  each species at each community, if \code{TRUE}, discrete functions (histograms) are
  estimated.

  If \code{circular = TRUE} and \code{discrete = FALSE}, the function \code{\link[circular]{circular}}
  is used to convert each column of \code{traits} to an object of class circular.
  Unless additional arguments about input data type are specified, it is
  assumed that the circular input data are in radian units (0 to 2*pi).

  If \code{circular = TRUE} and \code{discrete = TRUE}, data will be interpreted as
  discrete values on a circular scale. For example, data might be integer values
  representing hours and ranging from 0 to 23.

  If \code{run_null_model} is \code{TRUE}, the O-statistics are evaluated relative
  to a null model. When both \code{shuffle_weights} and \code{swap_means} are \code{FALSE},
  null communities are generated by randomly assigning a taxon that is present in the community to
  each individual. If \code{shuffle_weights} is \code{TRUE}, species abundances
  are also randomly assigned to each species to weight the O-statistic for each
  null community. If \code{swap_means} is \code{TRUE}, instead of sampling individuals
  randomly, species means are sampled randomly among species, keeping the deviation
  of each individual from its species mean the same. After the null communities
  are generated, O-stats are calculated for each null community to compare with
  the observed O-stat.

  Effect size statistics are calculated by z-transforming the O-statistics
  using the mean and standard deviation of the null distribution.
}
\examples{
# overlap statistics for body weights of small mammals in NEON sites

# Keep only the relevant part of data
dat <- small_mammal_data[small_mammal_data$siteID \%in\% c('HARV','JORN'), ]
dat <- dat[!is.na(dat$weight), ]
dat$log_weight <- log10(dat$weight)


#Run O-stats on the data with only a few null model iterations
Ostats_example <- Ostats(traits = as.matrix(dat[,'log_weight']),
                   sp = factor(dat$taxonID),
                   plots = factor(dat$siteID),
                   nperm = 10)
}
\references{
Read, Q. D. et al. Among-species overlap in rodent body size
  distributions predicts species richness along a temperature gradient.
  Ecography 41, 1718-1727 (2018).
}
\seealso{
\code{\link{Ostats_multivariate}} for multidimensional overlap.

\code{\link{Ostats_plot}} for plotting community overlap for
each community.
}
\author{
Quentin D. Read, John M. Grady, Arya Y. Yue, Isadora Fluck E., Ben Baiser,
Angela Strecker, Phoebe L. Zarnetske, and Sydne Record
}
