#' Sample Continuous Trait Data (NEON Small Mammals 2015)
#'
#' This is a sample dataset with small mammal data from all available
#' NEON sites in 2015.
#' Each row represents an individual small mammal that was
#' trapped and weighed, with its species identity, body weight in grams,
#' sex, and life stage provided.
#' Site name, site code, and sampling plot ID are provided.
#' This dataset is adapted from one published by Read et al. (2018).
#'
#' @references
#' NEON (National Ecological Observatory Network). Small mammal box trapping (DP1.10072.001). https://data.neonscience.org (accessed July 13, 2021)
#'
#' Read, Q.D., J.M. Grady, P.L. Zarnetske, S. Record, B. Baiser, J. Belmaker, M.-N. Tuanmu, A. Strecker, L. Beaudrot, and K.M. Thibault. 2018. Among-species overlap in rodent body size distributions predicts species richness along a temperature gradient. *Ecography* 41(10):1718-1727. https://doi.org/10.1111/ecog.03641
"small_mammal_data"
