% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_emulation.R
\name{psi_fn}
\alias{psi_fn}
\title{Updating function for variance.}
\usage{
psi_fn(n, nset, var_k2, N, var_u = 1e+07, k_width = 5000)
}
\arguments{
\item{n}{Set of training set sizes to evaluate at}

\item{nset}{Training set sizes for which k2() has been evaluated}

\item{var_k2}{Variance of error in k2() estimate at each training set size.}

\item{N}{Total number of samples on which the model will be fitted/used. Only used to rescale var_k2}

\item{var_u}{Marginal variance for Gaussian process kernel. Defaults to 1e7}

\item{k_width}{Kernel width for Gaussian process kernel. Defaults to 5000}
}
\value{
Vector Psi of same length of n where Psi_i=var(posterior(cost(n_i)))
}
\description{
Posterior variance for emulator given points \code{n}.
}
\examples{

# See examples for `mu_fn`

}
