% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-basicops.r
\name{swapPoles}
\alias{swapPoles}
\alias{reverse}
\title{Reverse constructs / swaps construct poles}
\usage{
swapPoles(x, pos)

reverse(x, pos = 1L:nrow(x))
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{pos}{Row indexes of constructs to reverse..}
}
\value{
A \code{repgrid} object with reversed constructs.
}
\description{
Constructs are bipolar. They can be reversed without a change in meaning. The
function swaps the constructs poles and re-adjusts ratings accordingly, i.e.
it reversed selected constructs.
}
\note{
Please note that the scale of the rating grid has to be set in order
to reverse constructs. If the scale is unknown no reversal occurs and an
error is raised.
}
\examples{

x <- boeker

reverse(x) # reverse all constructs
reverse(x, 1) # reverse construct 1
reverse(x, 1:2) # reverse constructs 1 and 2

# swapPoles will become deprecated, use reverse instead
swapPoles(x, 1) # swap construct poles of construct

}
\keyword{internal}
