% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importTxt}
\alias{importTxt}
\title{Import grid data from a text file.}
\usage{
importTxt(file, dir = NULL, min = NULL, max = NULL)
}
\arguments{
\item{file}{A vector of filenames including the full path if file is not in current working
directory. File can also be a complete URL. The file suffix
has to be \code{.txt}.}

\item{dir}{Alternative way to supply the directory where the file is located
(default \code{NULL}).}

\item{min}{Optional argument (\code{numeric}, default \code{NULL})
for minimum rating value in grid.}

\item{max}{Optional argument (\code{numeric}, default \code{NULL})
for maximum rating value in grid.}
}
\value{
A single \code{repgrid} object in case one file and
a list of \code{repgrid} objects in case multiple files are imported.
}
\description{
You can define a grid using a standard text editor and saving it as a \code{.txt} file.
The \emph{Details} section describes the required format of the \code{.txt} file. However, you may also
consider using the Excel format instead, as it has a more intuitive format (see \code{\link[=importExcel]{importExcel()}}).
}
\details{
The \code{.txt} file has to be in a fixed format. There are \emph{three mandatory blocks} each starting and ending
with a predefined tag in uppercase letters. The first block starts with \code{ELEMENTS} and ends with \verb{END ELEMENTS} and
contains one element in each line. The other mandatory blocks contain the constructs and ratings (see below). In the
block containing the constructs the left and right pole are separated by a colon (:). To define missing values use
\code{NA} like in the example below. One optional block contains the range of the rating scale used defined by two
numbers. The order of the blocks is arbitrary. All text not contained within the blocks is discarded and can thus be
used for comments.

The content of a sample \code{.txt} file is shown below. The package also contains a sample file (see \emph{Examples}).

\if{html}{\out{<div class="sourceCode">}}\preformatted{---------------- sample .txt file -------------------

    Note: anything outside the tag pairs is discarded

ELEMENTS
element 1
element 2
element 3
END ELEMENTS

CONSTRUCTS
left pole 1 : right pole 1
left pole 2 : right pole 2
left pole 3 : right pole 3
left pole 4 : right pole 4
END CONSTRUCTS

RATINGS
1 3 2
4 1 1
1 4 4
3 1 1
END RATINGS

RANGE
1 4
END RANGE

------------------ end of file ------------------
}\if{html}{\out{</div>}}

Note that the maximum and minimum value has to be defined using the \code{min} and \code{max} arguments if no \code{RANGE} block is
contained in the data file. Otherwise the scaling range is inferred from the available data and a warning is issued
as the range may be erroneous. This may effect other functions that depend on knowing the correct range and it is
thus strongly recommended to set the scale range correctly.
}
\examples{
# Import a .txt file delivered along with the package
file <- system.file("extdata", "grid_01.txt", package = "OpenRepGrid")
rg <- importTxt(file)

\dontrun{
# To see the structure of the Excel file try to open it as follows.
# May not work on all systems.
file.show(file)
}

# Import more than one .txt file
files <- system.file("extdata", c("grid_01.txt", "grid_02.txt"), package = "OpenRepGrid")
rgs <- importTxt(files)
}
\seealso{
\code{\link[=importGridcor]{importGridcor()}}, \code{\link[=importGridstat]{importGridstat()}}, \code{\link[=importScivesco]{importScivesco()}}, \code{\link[=importGridsuite]{importGridsuite()}}, \code{\link[=importTxt]{importTxt()}},
\code{\link[=importExcel]{importExcel()}}
}
