#' @title Converts a flow to a mlr learner.
#'
#' @description
#' Converts an \code{\link{OMLFlow}} that was originally created with the OpenML
#' R-package to a \code{\link[mlr]{Learner}}.
#'
#' @param flow [\code{\link{OMLFlow}}]\cr
#'   The flow object.
#'
#' @return [\code{\link[mlr]{Learner}}].
#' @family flow-related functions
#' @export
convertOMLFlowToMlr = function(flow) {
  assertClass(flow, "OMLFlow")
  if (!stri_startswith_fixed(flow$external.version, "R_") | is.na(flow$external.version))
    stopf("This flow can not be converted to a mlr learner. It was not generated by the OpenML R package.")
  if (stri_detect_regex(flow$external.version, "-v2[[:punct:]]")) {
    assertFile(flow$binary.path)
    return(readRDS(flow$binary.path))
  }
  return(mlr::makeLearner(flow$name))
}
