% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superpixels.R
\name{superpixels}
\alias{superpixels}
\title{SLIC and SLICO superpixel implementations}
\usage{
superpixels(input_image, method = "slic", superpixel = 200,
  compactness = 20, return_slic_data = FALSE,
  return_lab_data = FALSE, return_labels = FALSE, write_slic = "",
  verbose = FALSE)
}
\arguments{
\item{input_image}{either a 2-dimensional or a 3-dimensional input image (the range of the pixel values should be preferably in the range 0 to 255)}

\item{method}{a character string specifying the method to use. Either "slic" or "slico"}

\item{superpixel}{a numeric value specifying the number of superpixels to use}

\item{compactness}{a numeric value specifying the compactness parameter. The \emph{compactness} parameter is needed only if \emph{method} is "slic". The "slico" method adaptively chooses the compactness parameter for each superpixel differently.}

\item{return_slic_data}{a boolean. If TRUE then the resulted slic or slico data will be returned}

\item{return_lab_data}{a boolean. If TRUE then the Lab data will be returned ( the Lab-colour format )}

\item{return_labels}{a boolean. If TRUE then the labels will be returned}

\item{write_slic}{a character string. If not an empty string ("") then it should be a path to the output file with extension .bin ( for instance "/my_dir/output.bin" ). The data will be saved in binary format.}

\item{verbose}{a boolean. If TRUE then information will be printed in the R session}
}
\description{
SLIC and SLICO superpixel implementations
}
\examples{

library(OpenImageR)

#-------------------
# 3-dimensional data
#-------------------

path = system.file("tmp_images", "slic_im.png", package = "OpenImageR")

im = readImage(path)

res = superpixels(input_image = im, method = "slic", superpixel = 200,

                  compactness = 20, return_slic_data = TRUE)


#-------------------
# 2-dimensional data
#-------------------

im_2d = im[,,1]

res_mt = superpixels(input_image = im_2d, method = "slic", superpixel = 200,

                     compactness = 20, return_slic_data = TRUE)

}
\references{
https://ivrl.epfl.ch/research-2/research-current/research-superpixels
}
