% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_summary_validated.R
\name{miRNA_summary_validated}
\alias{miRNA_summary_validated}
\title{miRNA_summary_validated}
\usage{
miRNA_summary_validated(data, type = "class")
}
\arguments{
\item{data}{Requires a data frame generated by score_genes. Class - data frame}

\item{type}{Requires to specify a value for plotting. If plotting is performed for location select "location", alternatively select "class"; default is "class". Class - string}
}
\value{
a data frame with GC content; multiple plots are also plotted summarising the data
}
\description{
miRNA_summary_validated function provides information on genes that have known miRNA regulating them. The function checks  genes against known miRNA target database image and provides various plots to assess emerging data features. The user can also specify if the plotting is necessary for location ("location") or protein class ("class").
}
\examples{
\dontrun{
path_to_test_data<- system.file("extdata", "test_data.tabular", package="OmicInt")
# basic usage of miRNA_summary_validated
df<-utils::read.table(path_to_test_data)
return_df<-miRNA_summary_validated(df)
head(return_df)
}
}
