% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pairwise_stats.R
\name{plot_pairwise_stats}
\alias{plot_pairwise_stats}
\title{Create pairwise stats plot}
\usage{
plot_pairwise_stats(
  data,
  stats_col,
  group_col,
  label_col,
  y_axis_title = NULL,
  plot_title = NULL
)
}
\arguments{
\item{data}{A \link[base]{data.frame} or \link[data.table]{data.table}.}

\item{stats_col}{A column name of a continuous variable.}

\item{group_col}{A column name of a categorical variable.}

\item{label_col}{A column name of a categorical variable to label the bars.}

\item{y_axis_title}{A character variable to name the Y - axis title (default: NULL).}

\item{plot_title}{A character variable to name the plot title (default: NULL).}
}
\value{
A \link[ggplot2]{ggplot2} object to be further modified
}
\description{
Creates a pairwise stats plot from \link{pairwise_adonis} or \link{pairwise_anosim} results.
This function is built into the class \link{omics} with method \code{ordination()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
library("ggplot2")

# Create random data
set.seed(42)
mock_data <- matrix(rnorm(15 * 10), nrow = 15, ncol = 10)

# Create euclidean dissimilarity matrix
mock_dist <- dist(mock_data, method = "euclidean")

# Define group labels, should be equal to number of columns and rows to dist
mock_groups <- rep(c("A", "B", "C"), each = 5)

# Compute pairwise adonis
adonis_res <- pairwise_adonis(x = mock_dist, 
                              groups = mock_groups, 
                              p.adjust.method = "bonferroni", 
                              perm = 99)
# Compute pairwise anosim
anosim_res <- pairwise_anosim(x = mock_dist, 
                              groups = mock_groups, 
                              p.adjust.method = "bonferroni", 
                              perm = 99)

# Visualize PERMANOVA pairwise stats
plot_pairwise_stats(data = adonis_res,
                    group_col = "pairs",
                    stats_col = "F.Model",
                    label_col = "p.adj",
                    y_axis_title = "Pseudo F test statistic",
                    plot_title = "PERMANOVA")

# Visualize ANOSIM pairwise stats
plot_pairwise_stats(data = anosim_res,
                    group_col = "pairs",
                    stats_col = "anosimR",
                    label_col = "p.adj",
                    y_axis_title = "ANOSIM R statistic",
                    plot_title = "ANOSIM")
}
